package gov.cms.grouper.snf;

import com.mmm.his.cer.foundation.ComponentName;
import com.mmm.his.cer.foundation.ComponentPackage;
import com.mmm.his.cer.foundation.ComponentVersion;
import com.mmm.his.cer.foundation.Processable;
import com.mmm.his.cer.foundation.utility.ComponentClassUtil;

public enum SnfComponentName implements ComponentName, ComponentPackage {
  Snf;

  /**
   * The name of the component (the prefix of the {@link Processable}, {@link SnfComponentVersion}
   * and other class implementations).
   *
   * @return The component name, typically in sentence case to conform to the Java standards
   */
  @Override
  public String getName() {
    return name();
  }

  /**
   * The custom base package path on to which the {@link ComponentName} and {@link ComponentVersion}
   * will be appended.
   *
   * @return The base package path, with our without {@link ComponentClassUtil#PACKAGE_SEPARATOR} at
   *         the end.
   */
  @Override
  public String getBasePackagePath() {
    return "gov.cms.grouper";
  }
}
